/******************************************************************************
 * (C) Copyright 2000 by Agilent Technologies GmbH. All rights reserved.      *
 ******************************************************************************/

/* ---------------------------------------------------------------
 * File: xctdefs.h 
 *       Type Definitions for Completer-Target (CT) Functions
 * -----------------------------------------------------------------*/

#ifndef XCTDEFS_H_INCLUDED                               
#define XCTDEFS_H_INCLUDED

#ifndef CLI
#define CLI
#endif

/********************************************************************
  CT generics ***************************************************
 *******************************************************************/

#define BX_CTGENPROP_SIZE         6

CLI typedef enum {
  BX_CTGEN_NUMBEH,     /* @numbeh   */
  BX_CTGEN_NUMBEHG0,   /* @numbehg0 */
  BX_CTGEN_NUMBEHG1,   /* @numbehg1 */
  BX_CTGEN_NUMBEHG2,   /* @numbehg2 */
  BX_CTGEN_NUMBEHG3,   /* @numbehg3 */
  BX_CTGEN_NUMBEHG4    /* @numbehg4 */
} bx_ctgentype;

/********************************************************************
  CT behavior *******************************************************
 *******************************************************************/

CLI typedef enum {  
  BX_CTBEH_DECSPEED,     /* @decspeed      */ /* Group 3 */
  BX_CTBEH_ACK64,        /* @ack64         */ /* Group 3 */
  BX_CTBEH_INITIAL,      /* @initial       */ /* Group 1 */
  BX_CTBEH_LATENCY,      /* @latency       */ /* Group 1 */
  BX_CTBEH_SUBSEQ,       /* @subseq        */ /* Group 2 */
  BX_CTBEH_SUBSEQPHASE,  /* @subseqphase   */ /* Group 2 */
  BX_CTBEH_SPLITLATENCY, /* @splitlatency  */ /* Group 3 */
  BX_CTBEH_SPLITENABLE,  /* @splitenable   */ /* Group 3 */
  BX_CTBEH_REPEAT,       /* @repeat        */ /* Group 0 */
  BX_CTBEH_ENUMSIZE      /* $enumsize */
} bx_ctbehtype;

#define BX_CTBEHPROP_SIZE ((bx_int32)BX_CTBEH_ENUMSIZE)

CLI  /* DEF_START ~G_BX_CTBEH_DECSPEED */
#define BX_CTBEH_DECSPEED_A       0           /* @A @decspeeda */
#define BX_CTBEH_DECSPEED_B       1           /* @B @decspeedb */
#define BX_CTBEH_DECSPEED_C       2           /* @C @decspeedc */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_CTBEH_INITIAL */
#define BX_CTBEH_INITIAL_ACCEPT   0           /* @Accept */
#define BX_CTBEH_INITIAL_SINGLE   1           /* @Single */
#define BX_CTBEH_INITIAL_RETRY    2           /* @Retry */
#define BX_CTBEH_INITIAL_TABORT   3           /* @TAbort */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_CTBEH_SUBSEQ */
#define BX_CTBEH_SUBSEQ_ACCEPT     0          /* @Accept     */
#define BX_CTBEH_SUBSEQ_DISCONNECT 1          /* @Disconnect */
#define BX_CTBEH_SUBSEQ_TABORT     2          /* @Tabort     */
CLI  /* DEF_END */

/********************************************************************
  CT behavior groups ********************************************
*********************************************************************/

CLI typedef enum {
  BX_CTBEHGRP_0 = 1UL << 0UL, /* @ctbehgrp0 */
  BX_CTBEHGRP_1 = 1UL << 1UL, /* @ctbehgrp1 */
  BX_CTBEHGRP_2 = 1UL << 2UL, /* @ctbehgrp2 */
  BX_CTBEHGRP_3 = 1UL << 3UL, /* @ctbehgrp3 */
  BX_CTBEHGRP_4 = 1UL << 4UL, /* @ctbehgrp4 */
  BX_CTBEHGRP_ENUMSIZE        /* $enumsize */
} bx_ctbehgrptype;

#define BX_CTBEHGRP_SIZE BX_CTBEHGRP_ENUMSIZE
   
/********************************************************************
  CT split conditions *******************************************
********************************************************************/

#define BX_CTSPLITPROP_SIZE     7  /* number of props per instance */
#define BX_CTSPLITPROP_DEPTH    4  /* four decoders (instances)    */

CLI typedef enum {  
  BX_CTSPLIT_ADDRMASK_HI,  /* @addrmaskhi */ 
  BX_CTSPLIT_ADDRMASK_LO,  /* @addrmasklo */
  BX_CTSPLIT_ADDRVAL_HI,   /* @addrvalhi */
  BX_CTSPLIT_ADDRVAL_LO,   /* @addrvallo */
  BX_CTSPLIT_CMDS,         /* @cmds */
  BX_CTSPLIT_DEC,          /* @dec */
  BX_CTSPLIT_QUEUE         /* @queue */
} bx_ctsplittype;

CLI  /* DEF_START ~G_BX_CTSPLIT_CMDS */
#define BX_CTSPLIT_CMDS_NONE      0x0000 /* 0000 0000 0000 0000 \b */
#define BX_CTSPLIT_CMDS_READBLOCK 0x4100 /* 0100 0001 0000 0000 \b */
#define BX_CTSPLIT_CMDS_CONFIG    0x0c00 /* 0000 1100 0000 0000 \b */
#define BX_CTSPLIT_CMDS_MEM       0x4140 /* 0100 0001 0100 0000 \b */
#define BX_CTSPLIT_CMDS_IO        0x000c /* 0000 0000 0000 1100 \b */
#define BX_CTSPLIT_CMDS_ALL       0x4d4d /* 0100 1101 0100 1101 \b */
CLI  /* DEF_END */

/*
 * HL, 16-Aug-00,
 *  changed assignment to string table for CTSPLIT_BAR to go into
 *  BX_CTSPLIT_DEC_table
 */

CLI  /* DEF_START ~G_BX_CTSPLIT_DEC */
#define BX_CTSPLIT_DEC_NONE 0x00    /* @DecNone */
#define BX_CTSPLIT_DEC_ANY  0x3f    /* @DecAny */
#define BX_CTSPLIT_DEC_1    0x03    /* @Dec1   */
#define BX_CTSPLIT_DEC_2    0x0c    /* @Dec2   */
#define BX_CTSPLIT_DEC_3    0x30    /* @Dec3   */
#define BX_CTSPLIT_BAR_ANY  0x3f    /* @BarAny */
#define BX_CTSPLIT_BAR_0    0x01    /* @Bar0   */ 
#define BX_CTSPLIT_BAR_1    0x02    /* @Bar1   */
#define BX_CTSPLIT_BAR_2    0x04    /* @Bar2   */
#define BX_CTSPLIT_BAR_3    0x08    /* @Bar3   */
#define BX_CTSPLIT_BAR_4    0x10    /* @Bar4   */
#define BX_CTSPLIT_BAR_5    0x20    /* @Bar5   */
CLI  /* DEF_END */

CLI  /* DEF_START ~G_BX_CTSPLIT_QUEUE */
#define BX_CTSPLIT_QUEUE_A    0   /* @QueueA    */
#define BX_CTSPLIT_QUEUE_B    1   /* @QueueB    */
#define BX_CTSPLIT_QUEUE_C    2   /* @QueueC    */
#define BX_CTSPLIT_QUEUE_D    3   /* @QueueD    */
#define BX_CTSPLIT_QUEUE_NEXT 4   /* @QueueNext */
#define BX_CTSPLIT_QUEUE_AUTO 8   /* @QueueAuto */
CLI  /* DEF_END */

#endif
